#include <iostream>
#include <vector>

using namespace std;

long long max_army_size(int N, long long S, vector<long long>& m, vector<long long>& a, vector<long long>& l, vector<long long>& r) {
    long long army_size = S;
    for (int i = 0; i < N; ++i) {
        if (m[i] > 0) {
            army_size *= m[i];
        } else {
            army_size += a[i];
        }

        army_size = max(army_size, l[i]);
        army_size = min(army_size, r[i]);

        if (army_size < l[i] || army_size > r[i]) {
            return -1; // Nemoguce
        }
    }

    return army_size;
}

int main() {
    int T;
    cin >> T;

    for (int t = 0; t < T; ++t) {
        int N;
        long long S;
        cin >> N >> S;

        vector<long long> m(N), a(N), l(N), r(N);

        for (int i = 0; i < N; ++i) {
            cin >> m[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> a[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> l[i];
        }

        for (int i = 0; i < N; ++i) {
            cin >> r[i];
        }

        long long result = max_army_size(N, S, m, a, l, r);
        
        if (result == -1) {
            cout << "nemoguce" << endl;
        } else {
            cout << result << endl;
        }
    }

    return 0;
}